/****** Object:  Table [dbo].[EST_NF_ENT_CANCEL]    Script Date: 09/25/2013 16:00:24 ******/
IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_ENT_CANCEL]') AND type in (N'U'))
begin
	CREATE TABLE [dbo].[EST_NF_ENT_CANCEL](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_NF] [int] NOT NULL,
		[CD_USU] [int] NOT NULL,
		[DT_CANCEL] [datetime] NOT NULL,
		[DT_CAD] [datetime] NOT NULL,
                [CD_LOTE] int NULL,
                [NR_AUTORIZADOR]VARCHAR(100) NULL,
                [NR_PROTOCOLO]VARCHAR(100) NULL, 
                [JUSTIFICATIVA]VARCHAR(MAX) NULL, 
                [DS_RETORNO]VARCHAR(MAX) NULL,
                [DT_EVENTO]DATETIME NULL,  
	 CONSTRAINT [PK_EST_NF_ENT_CANCEL] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_NF] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]


	ALTER TABLE [dbo].[EST_NF_ENT_CANCEL]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_ENT_CANCEL_EST_NF_ENT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
	REFERENCES [dbo].[EST_NF_ENT] ([CD_EMP], [CD_FILIAL], [CD_NF])

	ALTER TABLE [dbo].[EST_NF_ENT_CANCEL] CHECK CONSTRAINT [FK_EST_NF_ENT_CANCEL_EST_NF_ENT]

	ALTER TABLE [dbo].[EST_NF_ENT_CANCEL] ADD  CONSTRAINT [DF_EST_NF_ENT_CANCEL_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[EST_NF_ENT_CANCEL] ADD  CONSTRAINT [DF_EST_NF_ENT_CANCEL_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

	ALTER TABLE [dbo].[EST_NF_ENT_CANCEL] ADD  CONSTRAINT [DF_EST_NF_ENT_CANCEL_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

	ALTER TABLE [dbo].[EST_NF_ENT_CANCEL] ADD  CONSTRAINT [DF_EST_NF_ENT_CANCEL_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

	ALTER TABLE [dbo].[EST_NF_ENT_CANCEL] ADD  CONSTRAINT [DF_EST_NF_ENT_CANCEL_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]
end